/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.tracing.opentelemetry;

import com.google.common.annotations.VisibleForTesting;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.tracing.TraceContext;
import org.openqa.selenium.remote.tracing.opentelemetry.OpenTelemetrySpan;

public class OpenTelemetryContext
implements TraceContext {
    private final Tracer tracer;
    private final Context context;
    private final SpanContext spanContext;

    public OpenTelemetryContext(Tracer tracer, Context context) {
        this.tracer = Require.nonNull("Tracer", tracer);
        this.context = Require.nonNull("Context", context);
        this.spanContext = Span.fromContext(context).getSpanContext();
    }

    @Override
    public String getId() {
        return this.spanContext.getSpanId();
    }

    @Override
    public OpenTelemetrySpan createSpan(String name) {
        Require.nonNull("Name", name);
        Span span = this.tracer.spanBuilder(name).setParent(this.context).startSpan();
        Context prev = Context.current();
        Scope scope = span.makeCurrent();
        if (prev.equals(Context.current())) {
            throw new IllegalStateException("Context has not been changed");
        }
        return new OpenTelemetrySpan(this.tracer, Context.current(), span, scope);
    }

    @VisibleForTesting
    Context getContext() {
        return this.context;
    }

    @Override
    public Runnable wrap(Runnable runnable) {
        return this.context.wrap(runnable);
    }

    @Override
    public <V> Callable<V> wrap(Callable<V> callable) {
        return this.context.wrap(callable);
    }

    public boolean equals(Object o) {
        if (!(o instanceof OpenTelemetryContext)) {
            return false;
        }
        OpenTelemetryContext that = (OpenTelemetryContext)o;
        return Objects.equals(this.context, that.context);
    }

    public int hashCode() {
        return Objects.hash(this.context);
    }

    public String toString() {
        return "OpenTelemetryContext{tracer=" + this.tracer + ", context=" + this.context + ", span id=" + this.spanContext.getSpanId() + ", trace id=" + this.spanContext.getTraceId() + "}";
    }
}

