/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import org.openqa.selenium.Capabilities;
import org.openqa.selenium.internal.Require;

public interface Browser {
    public static final Browser CHROME = () -> "chrome";
    public static final Browser EDGE = new Browser(){

        @Override
        public String browserName() {
            return "MicrosoftEdge";
        }

        @Override
        public boolean is(String browserName) {
            return this.browserName().equals(browserName) || "msedge".equals(browserName);
        }
    };
    public static final Browser HTMLUNIT = () -> "htmlunit";
    public static final Browser IE = () -> "internet explorer";
    public static final Browser FIREFOX = () -> "firefox";
    public static final Browser OPERA = new Browser(){

        @Override
        public String browserName() {
            return "opera";
        }

        @Override
        public boolean is(String browserName) {
            return this.browserName().equals(browserName);
        }
    };
    public static final Browser SAFARI = new Browser(){

        @Override
        public String browserName() {
            return "safari";
        }

        @Override
        public boolean is(String browserName) {
            return this.browserName().equals(browserName) || "Safari".equals(browserName);
        }
    };
    public static final Browser SAFARI_TECH_PREVIEW = new Browser(){

        @Override
        public String browserName() {
            return "Safari Technology Preview";
        }

        @Override
        public boolean is(String browserName) {
            return this.browserName().equals(browserName);
        }
    };

    public String browserName();

    default public boolean is(String browserName) {
        return this.browserName().equals(browserName);
    }

    default public boolean is(Capabilities caps) {
        Require.nonNull("Capabilities", caps);
        return this.is(caps.getBrowserName());
    }

    default public String toJson() {
        return this.browserName();
    }
}

