/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.netty.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import org.openqa.selenium.remote.http.BinaryMessage;
import org.openqa.selenium.remote.http.CloseMessage;
import org.openqa.selenium.remote.http.TextMessage;

class MessageInboundConverter
extends SimpleChannelInboundHandler<WebSocketFrame> {
    private static final Logger LOG = Logger.getLogger(MessageInboundConverter.class.getName());
    private Continuation next = Continuation.None;
    private StringBuilder builder;
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();

    public MessageInboundConverter() {
        this.builder = new StringBuilder();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void channelRead0(ChannelHandlerContext ctx, WebSocketFrame frame) {
        void var4_19;
        block27: {
            boolean finalFragment;
            block26: {
                finalFragment = frame.isFinalFragment();
                if (!(frame instanceof ContinuationWebSocketFrame)) break block26;
                switch (this.next) {
                    case Binary: {
                        try {
                            ByteBuf content = frame.content();
                            content.readBytes(this.buffer, content.readableBytes());
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException("failed to transfer buffer", e);
                        }
                        if (finalFragment) {
                            BinaryMessage binaryMessage = new BinaryMessage(this.buffer.toByteArray());
                            this.buffer.reset();
                            this.next = Continuation.None;
                        } else {
                            Object var4_9 = null;
                        }
                        break block27;
                    }
                    case Text: {
                        this.builder.append(((ContinuationWebSocketFrame)frame).text());
                        if (finalFragment) {
                            TextMessage textMessage = new TextMessage(this.builder.toString());
                            this.builder.setLength(0);
                            this.next = Continuation.None;
                        } else {
                            Object var4_11 = null;
                        }
                        break block27;
                    }
                    case None: {
                        ctx.write(frame);
                        return;
                    }
                    default: {
                        throw new IllegalStateException("unexpected enum: " + this.next);
                    }
                }
            }
            if (this.next != Continuation.None) {
                throw new IllegalStateException("expected a continuation frame");
            }
            if (frame instanceof TextWebSocketFrame) {
                if (finalFragment) {
                    TextMessage textMessage = new TextMessage(((TextWebSocketFrame)frame).text());
                } else {
                    this.next = Continuation.Text;
                    Object var4_13 = null;
                    this.builder.append(((TextWebSocketFrame)frame).text());
                }
            } else if (frame instanceof BinaryWebSocketFrame) {
                ByteBuf content = frame.content();
                if (finalFragment) {
                    if (content.nioBufferCount() != -1) {
                        BinaryMessage binaryMessage = new BinaryMessage(content.nioBuffer());
                    } else {
                        if (!content.hasArray()) throw new IllegalStateException("Unable to handle bytebuf: " + content);
                        BinaryMessage binaryMessage = new BinaryMessage(ByteBuffer.wrap(content.array()));
                    }
                } else {
                    this.next = Continuation.Binary;
                    Object var4_16 = null;
                    try {
                        content.readBytes(this.buffer, content.readableBytes());
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("failed to transfer buffer", e);
                    }
                }
            } else if (frame instanceof CloseWebSocketFrame) {
                CloseWebSocketFrame closeFrame = (CloseWebSocketFrame)frame;
                CloseMessage closeMessage = new CloseMessage(closeFrame.statusCode(), closeFrame.reasonText());
            } else {
                ctx.write(frame);
                return;
            }
        }
        if (var4_19 == null) return;
        ctx.fireChannelRead(var4_19);
    }

    private static enum Continuation {
        Text,
        Binary,
        None;

    }
}

