/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node.config;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.PersistentCapabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.devtools.CdpEndpointFinder;
import org.openqa.selenium.grid.data.CreateSessionRequest;
import org.openqa.selenium.grid.node.ActiveSession;
import org.openqa.selenium.grid.node.DefaultActiveSession;
import org.openqa.selenium.grid.node.SessionFactory;
import org.openqa.selenium.grid.node.config.SessionCapabilitiesMutator;
import org.openqa.selenium.internal.Either;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.manager.SeleniumManagerOutput;
import org.openqa.selenium.net.HostIdentifier;
import org.openqa.selenium.net.NetworkUtils;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.DriverCommand;
import org.openqa.selenium.remote.ProtocolHandshake;
import org.openqa.selenium.remote.RemoteTags;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.service.DriverFinder;
import org.openqa.selenium.remote.service.DriverService;
import org.openqa.selenium.remote.tracing.AttributeKey;
import org.openqa.selenium.remote.tracing.AttributeMap;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Status;
import org.openqa.selenium.remote.tracing.Tags;
import org.openqa.selenium.remote.tracing.Tracer;

public class DriverServiceSessionFactory
implements SessionFactory {
    private static final Logger LOG = Logger.getLogger(DriverServiceSessionFactory.class.getName());
    private final Tracer tracer;
    private final HttpClient.Factory clientFactory;
    private final Duration sessionTimeout;
    private final Predicate<Capabilities> predicate;
    private final DriverService.Builder<?, ?> builder;
    private final Capabilities stereotype;
    private final SessionCapabilitiesMutator sessionCapabilitiesMutator;

    public DriverServiceSessionFactory(Tracer tracer, HttpClient.Factory clientFactory, Duration sessionTimeout, Capabilities stereotype, Predicate<Capabilities> predicate, DriverService.Builder<?, ?> builder) {
        this.tracer = Require.nonNull("Tracer", tracer);
        this.clientFactory = Require.nonNull("HTTP client factory", clientFactory);
        this.sessionTimeout = Require.nonNull("Session timeout", sessionTimeout);
        this.stereotype = ImmutableCapabilities.copyOf(Require.nonNull("Stereotype", stereotype));
        this.predicate = Require.nonNull("Accepted capabilities predicate", predicate);
        this.builder = Require.nonNull("Driver service builder", builder);
        this.sessionCapabilitiesMutator = new SessionCapabilitiesMutator(this.stereotype);
    }

    @Override
    public Capabilities getStereotype() {
        return this.stereotype;
    }

    @Override
    public boolean test(Capabilities capabilities) {
        return this.predicate.test(capabilities);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Either<WebDriverException, ActiveSession> apply(CreateSessionRequest sessionRequest) {
        if (sessionRequest.getDownstreamDialects().isEmpty()) {
            return Either.left(new SessionNotCreatedException("No downstream dialects were found."));
        }
        if (!this.test(sessionRequest.getDesiredCapabilities())) {
            return Either.left(new SessionNotCreatedException("New session request capabilities do not match the stereotype."));
        }
        AttributeMap attributeMap = this.tracer.createAttributeMap();
        try (Span span = this.tracer.getCurrentContext().createSpan("driver_service_factory.apply");){
            Optional<String> browserVersion;
            Optional<Platform> platformName;
            Capabilities capabilities = this.sessionCapabilitiesMutator.apply(sessionRequest.getDesiredCapabilities());
            RemoteTags.CAPABILITIES.accept(span, capabilities);
            RemoteTags.CAPABILITIES_EVENT.accept(attributeMap, capabilities);
            attributeMap.put(AttributeKey.LOGGER_CLASS.getKey(), this.getClass().getName());
            Object service = this.builder.build();
            if (((DriverService)service).getExecutable() == null) {
                SeleniumManagerOutput.Result result = DriverFinder.getPath(service, capabilities);
                ((DriverService)service).setExecutable(result.getDriverPath());
                if (result.getBrowserPath() != null && !result.getBrowserPath().isEmpty()) {
                    capabilities = this.setBrowserBinary(capabilities, result.getBrowserPath());
                }
            }
            if ((platformName = Optional.ofNullable(capabilities.getPlatformName())).isPresent()) {
                capabilities = this.removeCapability(capabilities, "platformName");
            }
            if ((browserVersion = Optional.ofNullable(capabilities.getBrowserVersion())).isPresent()) {
                capabilities = this.removeCapability(capabilities, "browserVersion");
            }
            try {
                ((DriverService)service).start();
                URL serviceURL = ((DriverService)service).getUrl();
                attributeMap.put(AttributeKey.DRIVER_URL.getKey(), serviceURL.toString());
                ClientConfig clientConfig = ClientConfig.defaultConfig().readTimeout(this.sessionTimeout).baseUrl(serviceURL);
                HttpClient client = this.clientFactory.createClient(clientConfig);
                Command command = new Command(null, DriverCommand.NEW_SESSION(capabilities));
                ProtocolHandshake.Result result = new ProtocolHandshake().createSession((HttpHandler)client, command);
                Set<Dialect> downstreamDialects = sessionRequest.getDownstreamDialects();
                Dialect upstream = result.getDialect();
                Dialect downstream = downstreamDialects.contains((Object)result.getDialect()) ? result.getDialect() : downstreamDialects.iterator().next();
                Response response = result.createResponse();
                attributeMap.put(AttributeKey.UPSTREAM_DIALECT.getKey(), upstream.toString());
                attributeMap.put(AttributeKey.DOWNSTREAM_DIALECT.getKey(), downstream.toString());
                attributeMap.put(AttributeKey.DRIVER_RESPONSE.getKey(), response.toString());
                Capabilities caps = new ImmutableCapabilities((Map)response.getValue());
                if (platformName.isPresent()) {
                    caps = this.setInitialCapabilityValue(caps, "platformName", (Object)platformName.get());
                }
                if (caps.getBrowserVersion().isEmpty() && browserVersion.isPresent() && !browserVersion.get().isEmpty()) {
                    caps = this.setInitialCapabilityValue(caps, "browserVersion", browserVersion.get());
                }
                caps = this.readDevToolsEndpointAndVersion(caps);
                caps = this.readBiDiEndpoint(caps);
                caps = this.readVncEndpoint(capabilities, caps);
                span.addEvent("Driver service created session", attributeMap);
                Either<WebDriverException, ActiveSession> either = Either.right(new DefaultActiveSession(this.tracer, client, new SessionId(response.getSessionId()), ((DriverService)service).getUrl(), downstream, upstream, this.stereotype, caps, Instant.now(), (DriverService)service, client){
                    final /* synthetic */ DriverService val$service;
                    final /* synthetic */ HttpClient val$client;
                    {
                        this.val$service = driverService;
                        this.val$client = httpClient;
                        super(tracer, client, id, url, downstream, upstream, stereotype, capabilities, startTime);
                    }

                    @Override
                    public void stop() {
                        this.val$service.stop();
                        this.val$client.close();
                    }
                });
                return either;
            }
            catch (Exception e) {
                try {
                    span.setAttribute(AttributeKey.ERROR.getKey(), true);
                    span.setStatus(Status.CANCELLED);
                    Tags.EXCEPTION.accept(attributeMap, e);
                    String errorMessage = "Error while creating session with the driver service. Stopping driver service: " + e.getMessage();
                    LOG.warning(errorMessage);
                    attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), errorMessage);
                    span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
                    ((DriverService)service).stop();
                    Either<WebDriverException, ActiveSession> either = Either.left(new SessionNotCreatedException(errorMessage));
                    span.close();
                    return either;
                }
                catch (Exception e2) {
                    span.setAttribute(AttributeKey.ERROR.getKey(), true);
                    span.setStatus(Status.CANCELLED);
                    Tags.EXCEPTION.accept(attributeMap, e2);
                    String errorMessage = "Error while creating session with the driver service. " + e2.getMessage();
                    LOG.warning(errorMessage);
                    attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), errorMessage);
                    span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
                    Either<WebDriverException, ActiveSession> either = Either.left(new SessionNotCreatedException(e2.getMessage()));
                    return either;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    private Capabilities readDevToolsEndpointAndVersion(Capabilities caps) {
        class DevToolsInfo {
            public final URI cdpEndpoint;
            public final String version;

            public DevToolsInfo(URI cdpEndpoint, String version) {
                this.cdpEndpoint = cdpEndpoint;
                this.version = version;
            }
        }
        Function<Capabilities, Optional> chrome = c -> CdpEndpointFinder.getReportedUri("goog:chromeOptions", c).map(uri -> new DevToolsInfo((URI)uri, c.getBrowserVersion()));
        Function<Capabilities, Optional> edge = c -> CdpEndpointFinder.getReportedUri("ms:edgeOptions", c).map(uri -> new DevToolsInfo((URI)uri, c.getBrowserVersion()));
        Function<Capabilities, Optional> firefox = c -> CdpEndpointFinder.getReportedUri("moz:debuggerAddress", c).map(uri -> new DevToolsInfo((URI)uri, "85.0"));
        Optional<DevToolsInfo> maybeInfo = Stream.of(chrome, edge, firefox).map(finder -> (Optional)finder.apply(caps)).filter(Optional::isPresent).map(Optional::get).findFirst();
        if (maybeInfo.isPresent()) {
            DevToolsInfo info = maybeInfo.get();
            return new PersistentCapabilities(caps).setCapability("se:cdp", info.cdpEndpoint).setCapability("se:cdpVersion", info.version);
        }
        return caps;
    }

    private Capabilities readBiDiEndpoint(Capabilities caps) {
        Optional<String> webSocketUrl = Optional.ofNullable((String)caps.getCapability("webSocketUrl"));
        Optional<URI> websocketUri = webSocketUrl.map(uri -> {
            try {
                return new URI((String)uri);
            }
            catch (URISyntaxException e) {
                LOG.warning(e.getMessage());
                return null;
            }
        });
        if (websocketUri.isPresent()) {
            return new PersistentCapabilities(caps).setCapability("se:bidi", websocketUri.get());
        }
        return caps;
    }

    private Capabilities readVncEndpoint(Capabilities requestedCaps, Capabilities returnedCaps) {
        String seVncEnabledCap = "se:vncEnabled";
        String seNoVncPortCap = "se:noVncPort";
        String seVncEnabled = String.valueOf(requestedCaps.getCapability(seVncEnabledCap));
        boolean vncLocalAddressSet = requestedCaps.getCapabilityNames().contains("se:vncLocalAddress");
        if (Boolean.parseBoolean(seVncEnabled) && !vncLocalAddressSet) {
            String seNoVncPort = String.valueOf(requestedCaps.getCapability(seNoVncPortCap));
            String vncLocalAddress = String.format("ws://%s:%s", this.getHost(), seNoVncPort);
            returnedCaps = new PersistentCapabilities(returnedCaps).setCapability("se:vncLocalAddress", vncLocalAddress).setCapability(seVncEnabledCap, true);
        }
        return returnedCaps;
    }

    private Capabilities removeCapability(Capabilities caps, String capability) {
        MutableCapabilities removableCaps = new MutableCapabilities(new HashMap<String, Object>(caps.asMap()));
        removableCaps.setCapability(capability, (String)null);
        return new PersistentCapabilities(removableCaps);
    }

    private Capabilities setInitialCapabilityValue(Capabilities caps, String key, Object value) {
        return new PersistentCapabilities(caps).setCapability(key, value);
    }

    private String getHost() {
        try {
            return new NetworkUtils().getNonLoopbackAddressOfThisMachine();
        }
        catch (WebDriverException e) {
            return HostIdentifier.getHostName();
        }
    }

    private Capabilities setBrowserBinary(Capabilities options, String browserPath) {
        List<String> vendorOptionsCapabilities = Arrays.asList("moz:firefoxOptions", "goog:chromeOptions", "ms:edgeOptions");
        for (String vendorOptionsCapability : vendorOptionsCapabilities) {
            if (!options.asMap().containsKey(vendorOptionsCapability)) continue;
            try {
                Map vendorOptions = (Map)options.getCapability(vendorOptionsCapability);
                vendorOptions.put("binary", browserPath);
                return new PersistentCapabilities(options).setCapability(vendorOptionsCapability, vendorOptions);
            }
            catch (Exception e) {
                LOG.warning(String.format("Exception while setting the browser binary path. %s: %s", options, e.getMessage()));
            }
        }
        return options;
    }
}

