/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node;

import com.google.common.collect.ImmutableMap;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.SessionId;

public class CapabilityResponseEncoder {
    private static final Json JSON = new Json();
    private static final ResponseEncoder<Session, Map<String, Object>, byte[]> W3C_ENCODER = new Encoder(Dialect.W3C);

    private CapabilityResponseEncoder() {
    }

    public static ResponseEncoder<Session, Map<String, Object>, byte[]> getEncoder(Dialect dialect) {
        switch (dialect) {
            case W3C: {
                return W3C_ENCODER;
            }
        }
        throw new IllegalArgumentException("Unrecognised dialect: " + dialect);
    }

    public static interface ResponseEncoder<T, U, R>
    extends Function<T, R>,
    BiFunction<T, U, R> {
        @Override
        default public <V> ResponseEncoder<T, U, V> andThen(final Function<? super R, ? extends V> after) {
            return new ResponseEncoder<T, U, V>(){

                @Override
                public V apply(T t2, U u) {
                    return after.apply(this.apply(t2, u));
                }

                @Override
                public V apply(T t2) {
                    return after.apply(this.apply(t2));
                }
            };
        }
    }

    private static class Encoder
    implements ResponseEncoder<Session, Map<String, Object>, byte[]> {
        private final Dialect dialect;

        private Encoder(Dialect dialect) {
            this.dialect = Require.nonNull("Dialect", dialect);
        }

        @Override
        public byte[] apply(Session session, Map<String, Object> metadata) {
            Require.nonNull("Session", session);
            Require.nonNull("Metadata", metadata);
            return Encoder.encodeAsResponse(this.dialect, session.getId(), session.getCapabilities(), metadata);
        }

        @Override
        public byte[] apply(Session session) {
            return this.apply(session, (Map<String, Object>)ImmutableMap.of());
        }

        private static byte[] encodeAsResponse(Dialect dialect, SessionId id, Capabilities capabilities, Map<String, Object> metadata) {
            Map<String, Object> toEncode;
            switch (dialect) {
                case W3C: {
                    toEncode = Encoder.encodeW3C(id, capabilities, metadata);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown dialect: " + dialect);
                }
            }
            return JSON.toJson(toEncode).getBytes(StandardCharsets.UTF_8);
        }

        private static Map<String, Object> encodeW3C(SessionId id, Capabilities capabilities, Map<String, Object> metadata) {
            return ImmutableMap.builder().putAll(metadata).put("value", ImmutableMap.of("sessionId", id, "capabilities", capabilities)).build();
        }
    }
}

