/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openqa.selenium.Beta;
import org.openqa.selenium.docker.Device;
import org.openqa.selenium.docker.DockerException;
import org.openqa.selenium.docker.Image;
import org.openqa.selenium.docker.Port;
import org.openqa.selenium.internal.Require;

@Beta
public class ContainerConfig {
    private static final String DEFAULT_DOCKER_NETWORK = "bridge";
    private static final long DEFAULT_SHM_SIZE = 0x4000000L;
    private final Image image;
    private final Multimap<String, Map<String, Object>> portBindings;
    private final Map<String, String> envVars;
    private final Map<String, String> volumeBinds;
    private final List<Device> devices;
    private final String networkName;
    private final boolean autoRemove;
    private final long shmSize;

    public ContainerConfig(Image image, Multimap<String, Map<String, Object>> portBindings, Map<String, String> envVars, Map<String, String> volumeBinds, List<Device> devices, String networkName, long shmSize) {
        this.image = image;
        this.portBindings = portBindings;
        this.envVars = envVars;
        this.volumeBinds = volumeBinds;
        this.devices = devices;
        this.networkName = networkName;
        this.autoRemove = true;
        this.shmSize = shmSize;
    }

    public static ContainerConfig image(Image image) {
        return new ContainerConfig(image, HashMultimap.create(), ImmutableMap.of(), ImmutableMap.of(), ImmutableList.of(), DEFAULT_DOCKER_NETWORK, 0x4000000L);
    }

    public ContainerConfig map(Port containerPort, Port hostPort) {
        Require.nonNull("Container port", containerPort);
        Require.nonNull("Host port", hostPort);
        if (!hostPort.getProtocol().equals(containerPort.getProtocol())) {
            throw new DockerException(String.format("Port protocols must match: %s -> %s", hostPort, containerPort));
        }
        HashMultimap<String, Map<String, Object>> updatedBindings = HashMultimap.create(this.portBindings);
        updatedBindings.put(containerPort.getPort() + "/" + containerPort.getProtocol(), ImmutableMap.of("HostPort", String.valueOf(hostPort.getPort()), "HostIp", ""));
        return new ContainerConfig(this.image, updatedBindings, this.envVars, this.volumeBinds, this.devices, this.networkName, this.shmSize);
    }

    public ContainerConfig env(Map<String, String> envVars) {
        Require.nonNull("Container env vars", envVars);
        return new ContainerConfig(this.image, this.portBindings, envVars, this.volumeBinds, this.devices, this.networkName, this.shmSize);
    }

    public ContainerConfig bind(Map<String, String> volumeBinds) {
        Require.nonNull("Container volume binds", volumeBinds);
        return new ContainerConfig(this.image, this.portBindings, this.envVars, volumeBinds, this.devices, this.networkName, this.shmSize);
    }

    public ContainerConfig network(String networkName) {
        Require.nonNull("Container network name", networkName);
        return new ContainerConfig(this.image, this.portBindings, this.envVars, this.volumeBinds, this.devices, networkName, this.shmSize);
    }

    public ContainerConfig shmMemorySize(long shmSize) {
        return new ContainerConfig(this.image, this.portBindings, this.envVars, this.volumeBinds, this.devices, this.networkName, shmSize);
    }

    public ContainerConfig devices(List<Device> devices) {
        Require.nonNull("Container device files", devices);
        return new ContainerConfig(this.image, this.portBindings, this.envVars, this.volumeBinds, devices, this.networkName, this.shmSize);
    }

    public String toString() {
        return "ContainerConfig{image=" + this.image + ", portBindings=" + this.portBindings + ", envVars=" + this.envVars + ", volumeBinds=" + this.volumeBinds + ", networkName=" + this.networkName + ", devices=" + this.devices + ", autoRemove=" + this.autoRemove + ", shmSize=" + this.shmSize + "}";
    }

    private Map<String, Object> toJson() {
        List envVars = this.envVars.keySet().stream().map(key -> String.format("%s=%s", key, this.envVars.get(key))).collect(Collectors.toList());
        List volumeBinds = this.volumeBinds.keySet().stream().map(key -> String.format("%s:%s", key, this.volumeBinds.get(key))).collect(Collectors.toList());
        List devicesMapping = this.devices.stream().map(device -> ImmutableMap.of("PathOnHost", device.getPathOnHost(), "PathInContainer", device.getPathInContainer(), "CgroupPermissions", device.getCgroupPermissions())).collect(Collectors.toList());
        ImmutableMap hostConfig = ImmutableMap.of("PortBindings", this.portBindings.asMap(), "AutoRemove", this.autoRemove, "NetworkMode", this.networkName, "ShmSize", this.shmSize, "Binds", volumeBinds, "Devices", devicesMapping);
        return ImmutableMap.of("Image", this.image.getId(), "Env", envVars, "HostConfig", hostConfig);
    }
}

