/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi;

import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.bidi.BiDi;
import org.openqa.selenium.bidi.Event;
import org.openqa.selenium.bidi.HasBiDi;
import org.openqa.selenium.bidi.browsingcontext.BrowsingContextInfo;
import org.openqa.selenium.bidi.browsingcontext.NavigationInfo;
import org.openqa.selenium.bidi.browsingcontext.UserPromptClosed;
import org.openqa.selenium.bidi.browsingcontext.UserPromptOpened;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonInput;

public class BrowsingContextInspector
implements AutoCloseable {
    private static final Json JSON = new Json();
    private final Set<String> browsingContextIds;
    private final BiDi bidi;
    private final Function<Map<String, Object>, BrowsingContextInfo> browsingContextInfoMapper = params -> {
        try (StringReader reader = new StringReader(JSON.toJson(params));){
            JsonInput input = JSON.newInput(reader);
            try {
                BrowsingContextInfo browsingContextInfo = (BrowsingContextInfo)input.read((Type)((Object)BrowsingContextInfo.class));
                if (input != null) {
                    input.close();
                }
                return browsingContextInfo;
            }
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    };
    private final Function<Map<String, Object>, NavigationInfo> navigationInfoMapper = params -> {
        try (StringReader reader = new StringReader(JSON.toJson(params));){
            JsonInput input = JSON.newInput(reader);
            try {
                NavigationInfo navigationInfo = (NavigationInfo)input.read((Type)((Object)NavigationInfo.class));
                if (input != null) {
                    input.close();
                }
                return navigationInfo;
            }
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    };
    private final Event<BrowsingContextInfo> browsingContextCreated = new Event<BrowsingContextInfo>("browsingContext.contextCreated", this.browsingContextInfoMapper);
    private final Event<BrowsingContextInfo> browsingContextDestroyed = new Event<BrowsingContextInfo>("browsingContext.contextDestroyed", this.browsingContextInfoMapper);
    private final Event<UserPromptClosed> userPromptClosed = new Event<UserPromptClosed>("browsingContext.userPromptClosed", params -> {
        try (StringReader reader = new StringReader(JSON.toJson(params));){
            JsonInput input = JSON.newInput(reader);
            try {
                UserPromptClosed userPromptClosed = (UserPromptClosed)input.read((Type)((Object)UserPromptClosed.class));
                if (input != null) {
                    input.close();
                }
                return userPromptClosed;
            }
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    });
    private final Set<Event<NavigationInfo>> navigationEventSet = new HashSet<Event<NavigationInfo>>();
    private final Event<UserPromptOpened> userPromptOpened = new Event<UserPromptOpened>("browsingContext.userPromptOpened", params -> {
        try (StringReader reader = new StringReader(JSON.toJson(params));){
            JsonInput input = JSON.newInput(reader);
            try {
                UserPromptOpened userPromptOpened = (UserPromptOpened)input.read((Type)((Object)UserPromptOpened.class));
                if (input != null) {
                    input.close();
                }
                return userPromptOpened;
            }
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    });

    public BrowsingContextInspector(WebDriver driver) {
        this(new HashSet<String>(), driver);
    }

    public BrowsingContextInspector(String browsingContextId, WebDriver driver) {
        this(Collections.singleton(Require.nonNull("Browsing context id", browsingContextId)), driver);
    }

    public BrowsingContextInspector(Set<String> browsingContextIds, WebDriver driver) {
        Require.nonNull("WebDriver", driver);
        Require.nonNull("Browsing context id list", browsingContextIds);
        if (!(driver instanceof HasBiDi)) {
            throw new IllegalArgumentException("WebDriver instance must support BiDi protocol");
        }
        this.bidi = ((HasBiDi)((Object)driver)).getBiDi();
        this.browsingContextIds = browsingContextIds;
    }

    public void onBrowsingContextCreated(Consumer<BrowsingContextInfo> consumer) {
        if (this.browsingContextIds.isEmpty()) {
            this.bidi.addListener(this.browsingContextCreated, consumer);
        } else {
            this.bidi.addListener(this.browsingContextIds, this.browsingContextCreated, consumer);
        }
    }

    private void onBrowsingContextDestroyed(Consumer<BrowsingContextInfo> consumer) {
        if (this.browsingContextIds.isEmpty()) {
            this.bidi.addListener(this.browsingContextDestroyed, consumer);
        } else {
            this.bidi.addListener(this.browsingContextIds, this.browsingContextDestroyed, consumer);
        }
    }

    public void onNavigationStarted(Consumer<NavigationInfo> consumer) {
        this.addNavigationEventListener("browsingContext.navigationStarted", consumer);
    }

    public void onFragmentNavigated(Consumer<NavigationInfo> consumer) {
        this.addNavigationEventListener("browsingContext.fragmentNavigated", consumer);
    }

    public void onDomContentLoaded(Consumer<NavigationInfo> consumer) {
        this.addNavigationEventListener("browsingContext.domContentLoaded", consumer);
    }

    public void onBrowsingContextLoaded(Consumer<NavigationInfo> consumer) {
        this.addNavigationEventListener("browsingContext.load", consumer);
    }

    private void onDownloadWillBegin(Consumer<NavigationInfo> consumer) {
        this.addNavigationEventListener("browsingContext.downloadWillBegin", consumer);
    }

    private void onNavigationAborted(Consumer<NavigationInfo> consumer) {
        this.addNavigationEventListener("browsingContext.navigationAborted", consumer);
    }

    private void onNavigationFailed(Consumer<NavigationInfo> consumer) {
        this.addNavigationEventListener("browsingContext.navigationFailed", consumer);
    }

    public void onUserPromptClosed(Consumer<UserPromptClosed> consumer) {
        if (this.browsingContextIds.isEmpty()) {
            this.bidi.addListener(this.userPromptClosed, consumer);
        } else {
            this.bidi.addListener(this.browsingContextIds, this.userPromptClosed, consumer);
        }
    }

    public void onUserPromptOpened(Consumer<UserPromptOpened> consumer) {
        if (this.browsingContextIds.isEmpty()) {
            this.bidi.addListener(this.userPromptOpened, consumer);
        } else {
            this.bidi.addListener(this.browsingContextIds, this.userPromptOpened, consumer);
        }
    }

    private void addNavigationEventListener(String name, Consumer<NavigationInfo> consumer) {
        Event<NavigationInfo> navigationEvent = new Event<NavigationInfo>(name, this.navigationInfoMapper);
        this.navigationEventSet.add(navigationEvent);
        if (this.browsingContextIds.isEmpty()) {
            this.bidi.addListener(navigationEvent, consumer);
        } else {
            this.bidi.addListener(this.browsingContextIds, navigationEvent, consumer);
        }
    }

    @Override
    public void close() {
        this.bidi.clearListener(this.browsingContextCreated);
        this.bidi.clearListener(this.browsingContextDestroyed);
        this.bidi.clearListener(this.userPromptOpened);
        this.bidi.clearListener(this.userPromptClosed);
        this.navigationEventSet.forEach(this.bidi::clearListener);
    }
}

